(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3983,        155]*)
(*NotebookOutlinePosition[      4695,        180]*)
(*  CellTagsIndexPosition[      4651,        176]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(**EXHAUST\)\ \(MASS**\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[ExponentialE]^\((0.833295481466194587`\/38.183766184073562`)\)\)], 
  "Input"],

Cell[BoxData[
    \(1.02206316183845569`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(4.29079111653734202`*^15\/1.02206316183845569`\)], "Input"],

Cell[BoxData[
    \(4.19816629416444353`*^15\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(4.19816629416444353`*^15 - \ Mass\ of\ Eros\ after\ TOI\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(4.29079111653734202`*^15 - 4.19816629416444353`*^15\)], "Input"],

Cell[BoxData[
    \(9.26248223728985031`*^13\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(9.26248223728985031`*^13\  - \ Exhaust\ mass\ needed\)], "Input"],

Cell[BoxData[
    \(2500 - \ Rate\ of\ fire\ for\ each\ mass\ driver\ \((kg/s)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(2500*44924\)], "Input"],

Cell[BoxData[
    \(112310000\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(112310000\  - \ Rate\ of\ fire\ for\ all\ mass\ drivers\ \((kg/s)\)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve\ [9.26248223728985031`*^13\/112310000 - x \[Equal] 0, \ x]\)], 
  "Input"],

Cell[BoxData[
    \({{x \[Rule] 824724.622677397611`}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \({{x \[Rule] 824724.622677397611`}} - \ 
      The\ number\ of\ seconds\ needed\ to\ slow\ Eros\ down\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(824724.622677397611`/60\)], "Input"],

Cell[BoxData[
    \(13745.4103779566305`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(13745.4103779566305` - \ 
      The\ number\ of\ minutes\ needed\ to\ slow\ Eros\ down\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(13745.4103779566305`/60\)], "Input"],

Cell[BoxData[
    \(229.09017296594385`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(229.09017296594385` - \ 
      The\ number\ of\ hours\ needed\ to\ slow\ Eros\ down\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(229.09017296594385`/24\)], "Input"],

Cell[BoxData[
    \(9.54542387358099375`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(9.54542387358099375` - \ 
      The\ number\ of\ days\ needed\ to\ slow\ Eros\ down\)], "Input"]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 640}, {0, 424}},
WindowSize->{432, 400},
WindowMargins->{{55, Automatic}, {Automatic, 28}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 58, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[1792, 54, 100, 2, 42, "Input"],
Cell[1895, 58, 54, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[1986, 64, 79, 1, 42, "Input"],
Cell[2068, 67, 58, 1, 29, "Output"]
}, Open  ]],
Cell[2141, 71, 88, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[2254, 76, 84, 1, 30, "Input"],
Cell[2341, 79, 58, 1, 29, "Output"]
}, Open  ]],
Cell[2414, 83, 85, 1, 30, "Input"],
Cell[2502, 86, 93, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[2620, 91, 43, 1, 30, "Input"],
Cell[2666, 94, 43, 1, 29, "Output"]
}, Open  ]],
Cell[2724, 98, 103, 2, 30, "Input"],

Cell[CellGroupData[{
Cell[2852, 104, 100, 2, 42, "Input"],
Cell[2955, 108, 68, 1, 29, "Output"]
}, Open  ]],
Cell[3038, 112, 133, 2, 50, "Input"],

Cell[CellGroupData[{
Cell[3196, 118, 56, 1, 30, "Input"],
Cell[3255, 121, 54, 1, 29, "Output"]
}, Open  ]],
Cell[3324, 125, 119, 2, 50, "Input"],

Cell[CellGroupData[{
Cell[3468, 131, 56, 1, 30, "Input"],
Cell[3527, 134, 53, 1, 29, "Output"]
}, Open  ]],
Cell[3595, 138, 116, 2, 50, "Input"],

Cell[CellGroupData[{
Cell[3736, 144, 55, 1, 30, "Input"],
Cell[3794, 147, 54, 1, 29, "Output"]
}, Open  ]],
Cell[3863, 151, 116, 2, 50, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

